/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.
//
// And then further adapted to optimise it somewhat.  The improvement, while not
// huge, made a noticable difference with one of my more complex scenes. TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

vec3 circle(in vec2 r, in vec2 center, in float radius)
{
    float ret; // how much is it circle? (1.0 absolutely, 0.0 it is not)
    
    float a = smoothstep(0.0, 0.01, length(r-center)-radius);
    ret = smoothstep(1.0, 0.0, a);
    return vec3(ret);
}


vec3 rectangle(vec2 r, vec2 topLeft, vec2 bottomRight, in float angle) {
    float ret;
	mat2 rotationMatrix = mat2(cos(angle), -sin(angle),
                               sin(angle),  cos(angle));
    // Shift to normalize coordinates
    vec2 shift;
    shift.x = (abs(topLeft.x)<abs(bottomRight.x)?topLeft.x:bottomRight.x) + (abs(topLeft.x)<abs(bottomRight.x)?bottomRight.x-topLeft.x:topLeft.x-bottomRight.x)*0.5;
    shift.y = (abs(topLeft.y)<abs(bottomRight.y)?topLeft.y:bottomRight.y) + (abs(topLeft.y)<abs(bottomRight.y)?bottomRight.y-topLeft.y:topLeft.y-bottomRight.y)*0.5;

    // all shifted coordinates
    vec2 q = rotationMatrix * (r-shift);
    vec2 shifted_tl = topLeft - shift;
    vec2 shifted_br = bottomRight - shift;
	
	float d = 0.005;
	ret = smoothstep(shifted_tl.x-d, shifted_tl.x+d, q.x);
	ret *= smoothstep(shifted_tl.y-d, shifted_tl.y+d, q.y);
	ret *= 1.0 - smoothstep(shifted_br.y-d, shifted_br.y+d, q.y);
	ret *= 1.0 - smoothstep(shifted_br.x-d, shifted_br.x+d, q.x);
	return vec3(ret);
}


vec3 mouth(in vec2 r, in vec2 center, in float radius, in float weight)
{
    float ret = smoothstep(0.0, 0.01, float(abs(length(r-center)-radius)<weight && r.y<center.y) );
    return vec3(ret);
}

float sign(vec2 p1, vec2 p2, vec2 p3)
{
    return (p1.x - p3.x) * (p2.y - p3.y) - (p2.x - p3.x) * (p1.y - p3.y);
}
vec3 triangle(in vec2 r, in vec2 p1, in vec2 p2, in vec2 p3)
{
    // http://stackoverflow.com/questions/2049582/how-to-determine-a-point-in-a-triangle
    bool b1, b2, b3;
    
    b1 = sign(r, p1, p2) < 0.0;
    b2 = sign(r, p2, p3) < 0.0;
    b3 = sign(r, p3, p1) < 0.0;
    
    // TODO: Add antialiasing
    float a = float((b1==b2)&&(b2==b3));
    return vec3(a);
    //return vec3(smoothstep(0.0, 1.0, a));
}

// Snowman
// Takes in:
// ret - current pixel color so far
// r - current pixel position from [-1, -1] to [1, 1]
// center - center position of snowman
// scale - scale factor
void snowman2(inout vec3 ret, in vec2 r, in vec2 center, in float scale)
{
    vec3 membership;
    
    
    // circles (body)
    membership = circle(r, vec2(center.x, center.y+0.16*scale), 0.08*scale);
    membership+= circle(r, center, 0.12*scale);
    membership+= circle(r, vec2(center.x, center.y-0.25*scale), 0.2*scale);
    ret = mix(ret, vec3(1.0), membership);
    
    // Dots in center
    membership = circle(r, vec2(center.x, center.y+0.05*scale), 0.002*scale);
    membership+= circle(r, center, 0.002*scale);
    membership+= circle(r, vec2(center.x, center.y-0.05*scale), 0.002*scale);
    ret = mix(ret, vec3(0.0), membership);
    
    // Eyes
    membership+= circle(r, vec2(center.x+0.03, center.y+0.17*scale), 0.004*scale);
    membership+= circle(r, vec2(center.x-0.03, center.y+0.17*scale), 0.004*scale);
    ret = mix(ret, vec3(0.0), membership);
    
    // Carrot
    membership = triangle(r, 
                          vec2(center.x, center.y+0.16*scale), 
                          vec2(center.x, center.y+0.14*scale), 
                          vec2(center.x+0.04, center.y+0.145*scale));
    ret = mix(ret, vec3(0.7, 0.0, 0.0), membership);
    
    // Mouth
    membership = mouth(r, vec2(center.x, center.y+0.136*scale), 0.02, 0.002);
    ret = mix(ret, vec3(0.0, 0.0, 0.0), membership);
    
    
    // Hands
    membership = rectangle(r, vec2(center.x+0.15*scale, center.y-0.05*scale), vec2(center.x+0.16*scale, center.y+0.15*scale), -0.9);
    membership+= rectangle(r, vec2(center.x-0.16*scale, center.y-0.05*scale), vec2(center.x-0.15*scale, center.y+0.15*scale), 0.9);
    ret = mix(ret, vec3(0.0, 0.0, 0.0), membership);

    
    // Hat
    membership = rectangle(r, vec2(center.x-0.085*scale, center.y+0.20*scale), vec2(center.x+0.085*scale, center.y+0.25*scale), 0.03);
    ret = mix(ret, vec3(0.4, 0.0, 0.7), membership);
}



void snow(inout vec3 ret, in vec2 r, in float time)
{
    vec3 membership;
    
    membership = vec3(0.0);
    float x;
    for(float j=0.0; j < 1.0; j+=0.3)
    {
        for(float i=0.0; i < 1.0; i+=0.1)
        {   
            float y;
            //y = iGlobalTime * 0.3;
            y = (j*1.2) + iGlobalTime * 0.2 + 0.06*sin(i*25.0);
            x = (0.01*j*iGlobalTime) + i*1.8 + 0.01*cos(iGlobalTime*i*5.0);
            
            membership+= circle(r, vec2(0.895 - mod(x, 1.8), 0.5 - mod(y, 1.0)), 0.001*j*i);
            ret = mix(ret, vec3(0.9, 0.9, 1.0), membership);
        }
    }
}


// Draw hill
// Hill is actually half of circle and most of the half is moved out of the screen
void hill(inout vec3 ret, in vec2 r, in vec2 center, in float scale)
{
    vec2 p = r;
    vec3 membership;
    float min_y = float(r.y > center.y);
    
    // Border
    membership = circle(r, center, scale+0.005);
    ret = mix(ret, vec3(0.8, 0.8, 1.0), membership * min_y);
    
    // Hill gradient
    membership = circle(r, center, scale);    
    ret = mix(ret, 
              mix(vec3(0.97), vec3(0.85), smoothstep(center.y+scale, -0.5, r.y)),
              membership * min_y);
}



void nightsky(inout vec3 ret, in vec2 r, in float time)
{
    vec3 membership;
    
    membership = vec3(0.0);
    float x;
    for(float j=0.0; j < 1.0; j+=0.4)
    {
        for(float i=-1.0; i < 1.0; i+=0.4)
        {   
            float y;
            //y = iGlobalTime * 0.3;
            y = -0.2 + i + j + 0.05*sin(i*7.0);
            x = i + j*0.1;
            
            membership+= circle(r, vec2(0.895 - mod(x, 1.8), 0.5 - mod(y, 1.0)), 0.005*sin(mod(iGlobalTime*0.4, 3.14)-0.0));
            ret = mix(ret, vec3(1.0, 1.0, 0.0), membership);
        }
    }
}


void main ( void )
{
    // to [-1, -1] x [1, 1] - not really :)
    vec2 r = (gl_FragCoord.xy - 0.5 * iResolution.xy) / iResolution.y ;
    // output color rgb
    vec3 ret;
    // Background gradient
    ret = vec3(0.0, 1.0 - (r.y+1.4)*0.5, 1.0 - (r.y+0.9)*0.5);
    
    nightsky(ret, r, iGlobalTime);
    
    hill(ret, r, vec2(0.5, -1.2), 1.0);
    hill(ret, r, vec2(-0.3, -1.1), 1.0);
    
    snowman2(ret, r, vec2(-0.5,0.1), 0.8);
    snowman2(ret, r, vec2(-0.1, 0.04), 0.65);

    snow(ret, r, iGlobalTime);
    //ret = mix(ret, vec3(0.9, 0.1, 0.0), circle(r, vec2(0.0, -0.5), 0.01));
    //ret = mix(ret, vec3(0.9, 0.1, 0.0), circle(r, vec2(0.0, 0.5), 0.01));
    
    gl_FragColor = vec4(ret.x, ret.y, ret.z, 1.);
}